﻿Public Class Viewer

    Private Sub Viewer_Load(ByVal sender As Object, _
        ByVal e As System.EventArgs) Handles Me.Load

        Try
            'Tworzenie i używanie nowego egzemplarza klasy Favorites.
            Using objFavorites As New Favorites

                'Przeglądanie katalogu Favorites.
                objFavorites.ScanFavorites()

                'Przetwarzanie wszystkich obiektów objWebFavorite
                'z kolekcji FavoritesCollection.
                For Each objWebFavorite As WebFavorite In _
                    objFavorites.FavoritesCollection

                    'Deklaracja obiektu ListViewItem.
                    Dim objListViewItem As New ListViewItem

                    'Ustawienie właściwości obiektu ListViewItem.
                    objListViewItem.Text = objWebFavorite.Name
                    objListViewItem.SubItems.Add(objWebFavorite.Url)

                    'Dodanie obiektu ListViewItem do kontrolki ListView.
                    lvwFavorites.Items.Add(objListViewItem)
                Next

            End Using
        Catch ExceptionErr As Exception
                  'Wyświetlanie błędu.
            MessageBox.Show(ExceptionErr.Message, "Przeglądarka ulubionych", _
                MessageBoxButtons.OK, MessageBoxIcon.Warning)
        End Try

    End Sub

    Private Sub lvwFavorites_Click(ByVal sender As Object, _
        ByVal e As System.EventArgs) Handles lvwFavorites.Click

        'Aktualizacja właściwości Text kontrolki LinkLabel.
        lnkUrl.Text = "Otwórz " & lvwFavorites.SelectedItems.Item(0).Text

        'Wyczyszczenie domyślnego adresu.
        lnkUrl.Links.Clear()

           'Dodanie wybranego skrótu do kolekcji LinkCollection.
        lnkUrl.Links.Add(7, lvwFavorites.SelectedItems.Item(0).Text.Length, _
            lvwFavorites.SelectedItems.Item(0).SubItems(1).Text)
    End Sub

    Private Sub lnkUrl_LinkClicked(ByVal sender As Object, _
        ByVal e As System.Windows.Forms.LinkLabelLinkClickedEventArgs) _
        Handles lnkUrl.LinkClicked

        'Przetwarzanie wybranego skrótu.
        Process.Start(e.Link.LinkData)
    End Sub
End Class
